class MSCCustomWeapon extends MarkistanGuns
   abstract;

#exec TEXTURE IMPORT NAME=CustomWeaponIcon FILE=Textures\CustomWeaponIcon.PCX GROUP=Icons //Not much better to be done...

enum EWepModel
{
        WM_Undecided,
	WM_AssaultRifle,
	WM_StealthPistol,
	WM_AssaultShotgun,
	WM_Pistol,
	WM_SawedOffShotgun,
	WM_SniperRifle,
	WM_KS23,
	WM_Saiga12
};

enum EWepType
{
        WT_Undecided,
	WT_SMG,
	WT_Rifle,
	WT_Shotgun,
	WT_Handgun,
	WT_AutoShotgun,
        WT_AssaultRifle
};

var travel int WeaponMesh;
var travel bool bSpecAcc, bSpecPen, bSpecDam, bSpecScope, bSpecSilencer, bSpecKnockBack, bSpecClipSize, bSpecRecoil, bSpecRange;
var travel class<Ammo> CraftAmmo;
var travel int WeaponType;
var travel sound CFireSound, CSelectSound, CReloadSound, CFinishReloadSound;

var Vector ViewOffsets[10], FireOffsets[10];

//=============================================
//Certain Ammos are more effective
//=============================================
function Name WeaponDamageType()
{
 if (AmmoBarricade(AmmoType) != None) //solid steel (chance to gib lol)
 {
  if (FRand() > 0.20)
  {
   return 'Sabot';
  }
  else
  {
  return 'Exploded';
  }
 }
 
 if (AmmoStar(AmmoType) != None) //non-lethal
 {
  return 'KnockedOut';
 }

 if (AmmoSabot(AmmoType) != None)
 {
  return 'Sabot';
 }
 
 return Super.WeaponDamageType();
}

//=============================================
//Sniper Rifles blow up heads & Flash Shells
//Flash
//=============================================
function SpecialPTHShit(actor other, vector hitlocation, vector hitnormal, vector x, vector y, vector z)
{    
 local int j;
 local FleshFragment FF;
 
 if (WeaponType == 2 && (WeaponDamageType() == 'Shot' || WeaponDamageType() == 'Exploded' || WeaponDamageType() == 'Sabot'))
 {
 
 if ((Other.IsA('Pawn')) && (hitlocation.Z >= Other.Location.Z + 24) && (ScriptedPawn(Other) == None || ScriptedPawn(Other).bCanBleed) )
 {
	  for (j=0; j<hitDamage/8; j++)
	  {
			FF = spawn(class'FleshFragment',,,hitLocation); //boom, headshot!
			FF.DrawScale = 0.75;
			if ( WeaponDamageType() == 'Exploded' && FRand() < 0.1667)
			{
			 FF = spawn(class'FleshFragment',,,hitLocation); //extra gib power
			 FF.DrawScale = 0.65;
			 FF = spawn(class'FleshFragment',,,hitLocation);
			 FF.DrawScale = 0.8;
			 ScriptedPawn(Other).TakeDamage(HitDamage, Pawn(Owner), HitLocation, 1000.0*X, 'Exploded');
			}
	  }
 }
 
 }
 
 if (DeusExPlayer(Other) != None && AmmoStar(AmmoType) != None)
 {
  DeusExPlayer(Other).ClientFlash(1500, vect(1000,1000,900));
 }
 
 Super.SpecialPTHShit(Other,hitlocation,hitnormal,x,y,z);
}

//=============================================
//SMGs do double limb damage.
//=============================================
function processtracehit(actor other, vector hitlocation, vector hitnormal, vector x, vector y, vector z)
{
 local int H1, H2, H3, H4, H5;
 local name damageType;
 
 if (WeaponType == 1)
 {
  H1 = Pawn(Other).HealthLegLeft;
  H2 = Pawn(Other).HealthLegRight;
  H3 = Pawn(Other).HealthArmLeft;
  H4 = Pawn(Other).HealthArmRight;
  H5 = Pawn(Other).HealthTorso; 
 }
 
 damageType = WeaponDamageType();
 
 Super.Processtracehit(Other, hitLocation, hitNormal, x, y, z);
 
 //Bonus Limb Damage, though it wont apply for arms in MP. (causes upped torso damage too)
 
 if (WeaponType == 1)
 {
  if ( (H1 > Pawn(Other).HealthLegLeft) || (h2 > Pawn(other).HealthLegRight) || ( ((h3 > Pawn(other).HealthArmLeft) || (h4 > Pawn(other).HealthArmRight)) && (H5 <= Pawn(Other).HealthTorso)) )
  {
   Other.TakeDamage(HitDamage, Pawn(Owner), HitLocation, 1000.0*X, damageType);
  }
 }
}

simulated function vector CalcDrawOffset()
{
	local vector		DrawOffset, WeaponBob;
	local ScriptedPawn	SPOwner;
	local Pawn			PawnOwner;

	SPOwner = ScriptedPawn(Owner);
	if (SPOwner != None)
	{
		//DrawOffset = ((0.9/SPOwner.FOVAngle * GetCraftViewOffset() ) >> SPOwner.ViewRotation);
		DrawOffset = ((0.9/SPOwner.FOVAngle * PlayerViewOffset ) >> SPOwner.ViewRotation);
		DrawOffset += (SPOwner.BaseEyeHeight * vect(0,0,1));
	}
	else
	{
		// copied from Engine.Inventory to not be FOVAngle dependent
		PawnOwner = Pawn(Owner);
		//DrawOffset = ((0.9/PawnOwner.Default.FOVAngle * GetCraftViewOffset() ) >> PawnOwner.ViewRotation);
		DrawOffset = ((0.9/PawnOwner.Default.FOVAngle * PlayerViewOffset ) >> PawnOwner.ViewRotation);

		DrawOffset += (PawnOwner.EyeHeight * vect(0,0,1));
		WeaponBob = BobDamping * PawnOwner.WalkBob;
		WeaponBob.Z = (0.45 + 0.55 * BobDamping) * PawnOwner.WalkBob.Z;
		DrawOffset += WeaponBob;
	}

	return DrawOffset;
}

//====================================================
//Update: SON OF A BITCH! Player view offsets are
//        multiplied by 100 after the game begins
//        Very clever, inventory.uc, but your tricks
//        Shall work no more! ~WCCC
//====================================================
function Vector GetCraftViewOffset()
{
 local vector ViewOffset;
 
 if (WeaponMesh == 1) //Assault Rifle
 {
  FireOffset = FireOffsets[1];
  PlayerViewOffset = ViewOffsets[1] * 100;
 }

 if (WeaponMesh == 2) //Stealth Pistol
 {
  FireOffset = FireOffsets[2];
  PlayerViewOffset = ViewOffsets[2] * 100;
 }

 if (WeaponMesh == 3) //Assault Shotgun
 {
  FireOffset = FireOffsets[3];
  PlayerViewOffset = ViewOffsets[3] * 100;
 }

 if (WeaponMesh == 4) //Pistol
 {
  FireOffset = FireOffsets[4];
  PlayerViewOffset = ViewOffsets[4] * 100;
 }
 
 if (WeaponMesh == 5) //Sawed Off
 {
  FireOffset = FireOffsets[5];
  PlayerViewOffset = ViewOffsets[5] * 100;
 }

 if (WeaponMesh == 6) //Sniper Rifle
 {
  FireOffset = FireOffsets[6];
  PlayerViewOffset = ViewOffsets[6] * 100;
 }

 if (WeaponMesh == 7) //KS-23
 {
  FireOffset = FireOffsets[7];
  PlayerViewOffset = ViewOffsets[7] * 100;
 }

 if (WeaponMesh == 8) //Saiga 12
 {
  FireOffset = FireOffsets[8];
  PlayerViewOffset = ViewOffsets[8] * 100;
 }
 
 /*Default.FireSound = FireSound;
 Default.SelectSound = SelectSound;
 Default.CockingSound = CockingSound;
 Default.AltFireSound = AltFireSound;

 FireSound = FireSound;
 SelectSound = SelectSound;
 CockingSound = CockingSound;
 AltFireSound = AltFireSound;*/
 
 return ViewOffset;
}

simulated function SwapMuzzleFlashTexture()
{
   if (!bHasMuzzleFlash)
      return;

       if (WeaponMesh == 7 || WeaponMesh == 8)
       {
	if (Frand() < 0.5)
		MultiSkins[4] = Texture'SaigaCusMuz';
	else
		MultiSkins[5] = Texture'SaigaCusMuz';
       }

       if (WeaponMesh <= 6 && WeaponMesh != 2)
       {
	if (FRand() < 0.5)
		MultiSkins[2] = Texture'FlatFXTex34';
	else
		MultiSkins[2] = Texture'FlatFXTex37';
       }

	MuzzleFlashLight();
	SetTimer(0.1, False);
}

function Tick(float D)
{
 Super.Tick(D);
 
 //in other words we've lost out properties from save game loading or something similar.
 if (FireSound == None && SelectSound == None && AltFireSound == None && CockingSound == None)
 {
  UpdateCraftProperties(); //fix dat shit yo.
 }
 
}

simulated function EraseMuzzleFlashTexture()
{
	if (WeaponMesh == 7 || WeaponMesh == 8)
        {
	 MultiSkins[4] = Texture'BlackMaskTex';
	 MultiSkins[5] = Texture'BlackMaskTex';
	}
	if (WeaponMesh <= 6 && WeaponMesh != 2)
        {
	 MultiSkins[2] = Texture'BlackMaskTex';
	}
	
	GetCraftViewOffset();
}

function inventory SpawnCopy( pawn Other )
{
 local MSCCustomWeapon copy;

 copy = MSCCustomWeapon(Super.SpawnCopy(Other));
 copy.AmmoName = Self.AmmoName;
 copy.FireOffset = FireOffset;
 copy.PlayerViewOffset = PlayerViewOffset;
 copy.Default.FireOffset = FireOffset;
 copy.Default.PlayerViewOffset = PlayerViewOffset;
 copy.PlayerViewMesh = PlayerViewMesh;
 copy.PickupViewMesh = PickupViewMesh;
 copy.ThirdPersonMesh = ThirdPersonMesh;
 copy.Mesh = Mesh;
 copy.Texture = Texture;
 
 copy.Default.FireSound = FireSound;
 copy.Default.SelectSound = SelectSound;
 copy.Default.CockingSound = CockingSound;
 copy.Default.AltFireSound = AltFireSound;

 copy.FireSound = FireSound;
 copy.SelectSound = SelectSound;
 copy.CockingSound = CockingSound;
 copy.AltFireSound = AltFireSound;

 //properties to rebuild on startup
 copy.CFireSound = CFireSound;
 copy.CSelectSound = CSelectSound;
 copy.CReloadSound = CReloadSound;
 copy.CFinishReloadSound = CFinishReloadSound;
 copy.CraftAmmo = CraftAmmo;
 copy.WeaponMesh = WeaponMesh;
 copy.WeaponType = WeaponType;
 
 copy.bSpecAcc = bSpecAcc;
 copy.bSpecPen = bSpecPen;
 copy.bSpecDam = bSpecDam;
 copy.bSpecScope = bSpecScope;
 copy.bSpecSilencer = bSpecSilencer;
 copy.bSpecKnockBack = bSpecKnockBack;
 copy.bSpecClipSize = bSpecClipSize;
 copy.bSpecRecoil = bSpecRecoil;
 copy.bSpecRange = bSpecRange;
 
 copy.PenetrationPower = PenetrationPower;
 copy.AreaOfEffect = AreaOfEffect;
 copy.BaseAccuracy = BaseAccuracy;
 copy.Default.BaseAccuracy = BaseAccuracy;
 copy.ReloadCount = ReloadCount;
 copy.Default.ReloadCount = ReloadCount;
 copy.LowAmmoWaterMark = LowAmmoWaterMark;
 copy.RecoilStrength = RecoilStrength;
 copy.Default.RecoilStrength = RecoilStrength;
 copy.AccurateRange = AccurateRange;
 copy.MaxRange = MaxRange;
 copy.Default.AccurateRange = AccurateRange;
 copy.Default.MaxRange = MaxRange;
 copy.bKnockback = bKnockback;
 copy.KnockbackAmount = KnockbackAmount;
 copy.ShotTime = ShotTime;
 copy.Default.ShotTime = ShotTime;
 copy.bAutomatic = bAutomatic;
 copy.Default.bAutomatic = bAutomatic;

 copy.ShakeMag = ShakeMag;
 copy.GoverningSkill = GoverningSkill;
 copy.Default.GoverningSkill = GoverningSkill;
 copy.HitDamage = HitDamage;
 copy.Default.HitDamage = HitDamage;
 copy.PickupAmmoCount = PickupAmmoCount;
 copy.Mass = Mass;
 copy.Default.Mass = Mass;
 copy.ReloadTime = ReloadTime;
 copy.Default.ReloadTime = ReloadTime;
 
 copy.AmmoNames[0] = AmmoNames[0];
 copy.AmmoNames[1] = AmmoNames[1];
 copy.ProjectileNames[1] = ProjectileNames[1];

 //custom named shit.
 copy.Description = GetCraftDescription();
 copy.Default.Description = GetCraftDescription();
 
 return copy;
}

function string GetCraftDescription()
{
 local string S;
 local int i;
 
 if (bSpecAcc)
 {
  if (i > 0) S = S$" and";
  S = S$" Increased Accuracy";
  i++;
 }
 if (bSpecPen)
 {
  if (i > 0) S = S$" and";
  S = S$" Increased Penetration";
  i++;
 }
 if (bSpecDam)
 {
  if (i > 0) S = S$" and";
  S = S$" Increased Damage";
  i++;
 }
 if (bSpecScope)
 {
  if (i > 0) S = S$" and";
  S = S$" a Scope";
  i++;
 }
 if (bSpecSilencer)
 {
  if (i > 0) S = S$" and";
  S = S$" a Silencer";
  i++;
 }
 if (bSpecKnockBack)
 {
  if (i > 0) S = S$" and";
  S = S$" Increased Knockback";
  i++;
 }
 if (bSpecClipSize)
 {
  if (i > 0) S = S$" and";
  S = S$" an Extended Magazine";
  i++;
 }
 if (bSpecRecoil)
 {
  if (i > 0) S = S$" and";
  S = S$" Decreased Recoil";
  i++;
 }
 if (bSpecRange)
 {
  if (i > 0) S = S$" and";
  S = S$" Increased Range";
  i++;
 }
 
 return "A gun you customized yourself with"$S$".";
}

function UpdateCraftProperties() //PostBeginPlay was being called too fast, so this is 
				 //now called manually.
{
 //Super.PostBeginPlay();
 
 AmmoName = CraftAmmo;
 
 Description = GetCraftDescription();
 Default.Description = GetCraftDescription();
 
 FireSound = CFireSound;
 SelectSound = CSelectSound;
 CockingSound = CReloadSound;
 AltFireSound = CFinishReloadSound;

 Default.FireSound = CFireSound;
 Default.SelectSound = CSelectSound;
 Default.CockingSound = CReloadSound;
 Default.AltFireSound = CFinishReloadSound;
 
 if (WeaponType == 0 || WeaponMesh == 0)
 {
  Log("ERROR: Custom weapon spawned with null properties.");
  Destroy();
 }
 
 if (WeaponType == 1) //SMG
 {
  Default.AreaOfEffect = AOE_Point;
  Default.BaseAccuracy = 0.785000;
  Default.ReloadCount = 25;
  Default.LowAmmoWaterMark = 25;
  Default.RecoilStrength = 0.750000;
  
  PenetrationPower = 24;
  AreaOfEffect = AOE_Point;
  BaseAccuracy = 0.785000;
  ReloadCount = 25;
  LowAmmoWaterMark = 25;
  RecoilStrength = 0.750000;
  AccurateRange = 1200;
  MaxRange = 1200;
  Default.AccurateRange = 1200;
  Default.MaxRange = 1200;
  bKnockback = True;
  KnockbackAmount = 25;
  ShotTime = 0.200000;
  Default.ShotTime = 0.200000;
  bAutomatic = True;
  ShakeMag = 200;
  GoverningSkill = class'SkillWeaponRifle';
  HitDamage = 6;
  Default.HitDamage = 6;
  PickupAmmoCount = 75;
  Mass = 30;
  Default.Mass = 30;
  ReloadTime = 2.250000;
 }
 
 if (WeaponType == 2) //Rifle
 {
  Default.AreaOfEffect = AOE_Point;
  Default.BaseAccuracy = 0.250000;
  Default.ReloadCount = 5;
  Default.LowAmmoWaterMark = 5;
  Default.RecoilStrength = 0.600000;
  
  PenetrationPower = 60;
  AreaOfEffect = AOE_Point;
  BaseAccuracy = 0.250000;
  ReloadCount = 5;
  LowAmmoWaterMark = 5;
  RecoilStrength = 0.600000;
  AccurateRange = 28800;
  MaxRange = 28800;
  Default.AccurateRange = 28800;
  Default.MaxRange = 28800;
  bKnockback = True;
  KnockbackAmount = 75;
  ShotTime = 1.200000;
  Default.ShotTime = 1.200000;
  bAutomatic = False;
  ShakeMag = 200;
  GoverningSkill = class'SkillWeaponRifle';
  HitDamage = 40;
  Default.HitDamage = 40;
  PickupAmmoCount = 20;
  Mass = 30;
  Default.Mass = 30;
  ReloadTime = 2.750000;
 }
 
 if (WeaponType == 3) //Pump Shotgun
 {
  Default.AccurateRange = 1200;
  Default.MaxRange = 1200;
  
  Default.AreaOfEffect = AOE_Cone;
  Default.BaseAccuracy = 0.675000;
  Default.ReloadCount = 4;
  Default.LowAmmoWaterMark = 8;
  Default.RecoilStrength = 0.500000;
  
  PenetrationPower = 35;
  AreaOfEffect = AOE_Cone;
  BaseAccuracy = 0.675000;
  ReloadCount = 4;
  LowAmmoWaterMark = 8;
  RecoilStrength = 0.500000;
  AccurateRange = 1200;
  MaxRange = 1200;
  bKnockback = True;
  KnockbackAmount = 150;
  ShotTime = 0.200000;
  Default.ShotTime = 0.200000;
  bAutomatic = False;
  ShakeMag = 50;
  GoverningSkill = class'SkillWeaponRifle';
  HitDamage = 12;
  Default.HitDamage = 12;
  PickupAmmoCount = 24;
  Mass = 15;
  Default.Mass = 15;
  ReloadTime = 1.850000;
 }
 
 if (WeaponType == 4) //Handgun
 {
  Default.AccurateRange = 1200;
  Default.MaxRange = 1200;
  
  Default.AreaOfEffect = AOE_Point;
  Default.BaseAccuracy = 0.600000;
  Default.ReloadCount = 12;
  Default.LowAmmoWaterMark = 12;
  Default.RecoilStrength = 0.300000;
  
  PenetrationPower = 80;
  AreaOfEffect = AOE_Point;
  BaseAccuracy = 0.600000;
  ReloadCount = 12;
  LowAmmoWaterMark = 12;
  RecoilStrength = 0.300000;
  AccurateRange = 1200;
  MaxRange = 1200;
  bKnockback = True;
  KnockbackAmount = 80;
  ShotTime = 0.277500;
  Default.ShotTime = 0.277500;
  bAutomatic = False;
  ShakeMag = 50;
  GoverningSkill = class'SkillWeaponPistol';
  HitDamage = 18;
  Default.HitDamage = 18;
  PickupAmmoCount = 36;
  Mass = 15;
  Default.Mass = 15;
  ReloadTime = 0.700000;
 }
 
 if (WeaponType == 5) //Auto Shotgun
 {
  Default.AccurateRange = 1800;
  Default.MaxRange = 1800;
  
  Default.AreaOfEffect = AOE_Cone;
  Default.BaseAccuracy = 0.800000;
  Default.ReloadCount = 12;
  Default.LowAmmoWaterMark = 12;
  Default.RecoilStrength = 0.700000;
  
  PenetrationPower = 24;
  AreaOfEffect = AOE_Cone;
  BaseAccuracy = 0.800000;
  ReloadCount = 12;
  LowAmmoWaterMark = 12;
  RecoilStrength = 0.700000;
  AccurateRange = 1800;
  MaxRange = 1800;
  bKnockback = True;
  KnockbackAmount = 80;
  ShotTime = 0.700000;
  Default.ShotTime = 0.700000;
  bAutomatic = True;
  ShakeMag = 50;
  GoverningSkill = class'SkillWeaponHeavy';
  HitDamage = 9;
  Default.HitDamage = 9;
  PickupAmmoCount = 36;
  Mass = 30;
  Default.Mass = 30;
  ReloadTime = 2.750000;
 }
 
 if (WeaponType == 6) //AssaultRifle
 {
  Default.AccurateRange = 2500;
  Default.MaxRange = 2500;
  
  Default.AreaOfEffect = AOE_Point;
  Default.BaseAccuracy = 0.650000;
  Default.ReloadCount = 30;
  Default.LowAmmoWaterMark = 30;
  Default.RecoilStrength = 0.400000;
  
  PenetrationPower = 16;
  AreaOfEffect = AOE_Point;
  BaseAccuracy = 0.650000;
  ReloadCount = 30;
  LowAmmoWaterMark = 30;
  RecoilStrength = 0.400000;
  AccurateRange = 2500;
  MaxRange = 2500;
  bKnockback = True;
  KnockbackAmount = 110;
  ShotTime = 0.200000;
  Default.ShotTime = 0.200000;
  bAutomatic = True;
  Default.bAutomatic = True;
  ShakeMag = 50;
  AmmoNames[0] = CraftAmmo;
  AmmoNames[1] = class'Ammo20mm';
  ProjectileNames[1] = class'MSC20mmCannister';
  GoverningSkill = class'SkillWeaponRifle';
  HitDamage = 8;
  Default.HitDamage = 8;
  PickupAmmoCount = 90;
  Mass = 30;
  Default.Mass = 30;
  ReloadTime = 2.000000;
 }
 
 if (WeaponMesh == 1) //Assault Rifle
 {
  Default.FireOffset = FireOffsets[1];
  FireOffset = FireOffsets[1];
  PlayerViewOffset = ViewOffsets[1] * 100;
  PlayerViewMesh = LodMesh'AssaultGun';
  PickupViewMesh = LodMesh'AssaultGunPickup';
  ThirdPersonMesh = LodMesh'AssaultGun3rd';
  if (Owner == None) Mesh = LodMesh'AssaultGunPickup';
 }

 if (WeaponMesh == 2) //Stealth Pistol
 {
  Default.FireOffset = FireOffsets[2];
  FireOffset = FireOffsets[2];
  PlayerViewOffset = ViewOffsets[2] * 100;
  PlayerViewMesh = LodMesh'StealthPistol';
  PickupViewMesh = LodMesh'StealthPistolPickup';
  ThirdPersonMesh = LodMesh'StealthPistol3rd';
  if (Owner == None) Mesh = LodMesh'StealthPistolPickup';
 }

 if (WeaponMesh == 3) //Assault Shotgun
 {
  Default.FireOffset = FireOffsets[3];
  FireOffset = FireOffsets[3];
  PlayerViewOffset = ViewOffsets[3] * 100;
  PlayerViewMesh = LodMesh'AssaultShotgun';
  PickupViewMesh = LodMesh'AssaultShotgunPickup';
  ThirdPersonMesh = LodMesh'AssaultShotgun3rd';
  if (Owner == None) Mesh = LodMesh'AssaultShotgunPickup';
 }

 if (WeaponMesh == 4) //Pistol
 {
  Default.FireOffset = FireOffsets[4];
  FireOffset = FireOffsets[4];
  PlayerViewOffset = ViewOffsets[4] * 100;
  PlayerViewMesh = LodMesh'Glock';
  PickupViewMesh = LodMesh'GlockPickup';
  ThirdPersonMesh = LodMesh'Glock3rd';
  if (Owner == None) Mesh = LodMesh'GlockPickup';
 }
 
 if (WeaponMesh == 5) //Sawed Off
 {
  Default.FireOffset = FireOffsets[5];
  FireOffset = FireOffsets[5];
  PlayerViewOffset = ViewOffsets[5] * 100;
  PlayerViewMesh = LodMesh'Shotgun';
  PickupViewMesh = LodMesh'ShotgunPickup';
  ThirdPersonMesh = LodMesh'Shotgun3rd';
  if (Owner == None) Mesh = LodMesh'ShotgunPickup';
 }

 if (WeaponMesh == 6) //Sniper Rifle
 {
  Default.FireOffset = FireOffsets[6];
  FireOffset = FireOffsets[6];;
  PlayerViewOffset = ViewOffsets[6] * 100;
  PlayerViewMesh = LodMesh'SniperRifle';
  PickupViewMesh = LodMesh'SniperRiflePickup';
  ThirdPersonMesh = LodMesh'SniperRifle3rd';
  if (Owner == None) Mesh = LodMesh'SniperRiflePickup';
 }

 if (WeaponMesh == 7) //KS-23
 {
  Default.FireOffset = FireOffsets[7];
  FireOffset = FireOffsets[7];
  PlayerViewOffset = ViewOffsets[7] * 100;
  PlayerViewMesh = LodMesh'KS231st';
  PickupViewMesh = LodMesh'KS23Pickup';
  ThirdPersonMesh = LodMesh'KS233rd';
  if (Owner == None) Mesh = LodMesh'KS23Pickup';
  Texture = Texture'ReflectionMapTex2';
 }

 if (WeaponMesh == 8) //Saiga 12
 {
  Default.FireOffset = FireOffsets[8];
  FireOffset = FireOffsets[8];
  PlayerViewOffset = ViewOffsets[8] * 100;
  PlayerViewMesh = LodMesh'Saiga121st';
  PickupViewMesh = LodMesh'Saiga12Pickup';
  ThirdPersonMesh = LodMesh'Saiga123rd';
  if (Owner == None) Mesh = LodMesh'Saiga12Pickup';
  Texture = Texture'ReflectionMapTex2';
 }
 
 ApplySpecMods();
}

function ApplySpecMods()
{
 local int PBonus, DBonus, KBonus, CBonus;
 
 if (bSpecAcc)
 {
  BaseAccuracy = BaseAccuracy - 0.200000;
  Default.BaseAccuracy = BaseAccuracy;
 }
 if (bSpecPen)
 {
  PBonus = PenetrationPower / 4 * 3;
  if (PBonus < 20) PBonus = 20;
  PenetrationPower = PenetrationPower + PBonus;
 }
 if (bSpecDam)
 {
  DBonus = hitDamage / 5;
  if (DBonus < 2) DBonus = 2;
  hitDamage = hitDamage + DBonus;
  Default.hitDamage = hitDamage;
 }
 if (bSpecScope) bHasScope = True;
 if (bSpecSilencer) bHasSilencer = True;
 if (bSpecKnockBack)
 {
  KBonus = KnockbackAmount / 2;
  if (KBonus < 65) KBonus = 65;
  KnockbackAmount = KnockbackAmount + KBonus;
 }
 if (bSpecClipSize)
 {
  CBonus = ReloadCount / 2;
  if (CBonus < 3) CBonus = 3;
  ReloadCount = ReloadCount + CBonus;
  Default.ReloadCount = ReloadCount;
 }
 if (bSpecRecoil) RecoilStrength = RecoilStrength * 0.666;
 if (bSpecRange)
 {
  MaxRange = MaxRange + (MaxRange / 2);
  AccurateRange = AccurateRange + (AccurateRange / 2);
  Default.MaxRange = MaxRange;
  Default.AccurateRange = AccurateRange;
 }
 
}

defaultproperties
{
     ProjectileNames(1)=class'MSC20mmCannister'
     BaseAccuracy=0.000000
     LowAmmoWaterMark=30
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     NoiseLevel=2.000000
     EnviroEffective=ENVEFF_Air
     ShotTime=0.200000
     reloadTime=1.000000
     HitDamage=8
     maxRange=24000
     AccurateRange=14400
     bCanHaveScope=True 
     bHasScope=False
     bCanHaveSilencer=True
     bHasMuzzleFlash=True
     recoilStrength=1.000000
     bUseWhileCrouched=True
     AmmoName=Class'DeusEx.Ammo10mm'
     ReloadCount=4
     PickupAmmoCount=80
     FireOffset=(X=0.000000,Y=0.000000,Z=0.000000)
     shakemag=25.000000
     FireSound=None
     CockingSound=None
     SelectSound=None
     AltFireSound=None
     InventoryGroup=255
     ItemName="Custom Built Weapon"
     PlayerViewOffset=(X=0.000000,Y=0.000000,Z=-80.000000)
     PlayerViewMesh=LodMesh'DeusExItems.GEPGun'
     PickupViewMesh=LodMesh'DeusExItems.GEPGunPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.GEPGun3rd'
     LandSound=Sound'DeusExSounds.Generic.DropSmallWeapon'
     Icon=Texture'CustomWeaponIcon'
     largeIcon=Texture'CustomWeaponIcon'
     largeIconWidth=48
     largeIconHeight=48
     invSlotsX=1
     invSlotsY=1
     Description="A gun you customized yourself, or so I'd hope."
     beltDescription="|p4Custom Gun"
     Mesh=LodMesh'DeusExItems.GEPGunPickup'
     CollisionRadius=15.000000
     CollisionHeight=5.600000
     Mass=10.000000
     Texture=Texture'ReflectionMapTex2'
     bInstantHit=True
     ViewOffsets(1)=(X=16.000000,Y=5.000000,Z=-11.500000)
     ViewOffsets(2)=(X=24.000000,Y=10.000000,Z=-14.000000)
     ViewOffsets(3)=(X=30.000000,Y=10.000000,Z=-12.000000)
     ViewOffsets(4)=(X=22.000000,Y=10.000000,Z=-14.000000)
     ViewOffsets(5)=(X=11.000000,Y=4.000000,Z=-13.000000)
     ViewOffsets(6)=(X=20.000000,Y=2.000000,Z=-30.000000)
     ViewOffsets(7)=(X=25.000000,Y=15.000000,Z=-26.500000)
     ViewOffsets(8)=(X=20.000000,Y=7.000000,Z=-12.000000)
     FireOffsets(1)=(X=-16.000000,Y=-5.000000,Z=11.500000)
     FireOffsets(2)=(X=-24.000000,Y=-10.000000,Z=14.000000)
     FireOffsets(3)=(X=-30.000000,Y=-10.000000,Z=12.000000)
     FireOffsets(4)=(X=-22.000000,Y=-10.000000,Z=14.000000)
     FireOffsets(5)=(X=-11.000000,Y=-4.000000,Z=13.000000)
     FireOffsets(6)=(X=-20.000000,Y=-2.000000,Z=30.000000)
     FireOffsets(7)=(X=-25.000000,Y=-15.000000,Z=29.500000)
     FireOffsets(8)=(X=-20.000000,Y=-7.000000,Z=12.000000)
}
